The Characteristics Information Base (CIB) is a repository that stores information about hosts (e.g., available interfaces, supported protocols), connections (e.g., parameters used by previously established transport sessions, hosts currently communicating) and the network (e.g., path properties). CIB entries provide measured information, protocol details and capabilities about network entities used in the NEAT System, specifically in the policy decision phase.

The NEAT CIB acts as a filter of potential connection candidates.

# CIB format

Each entry or *row* of the CIB is comprised of an arbitrary number of *NEAT Properties*. Rows are composed from one or more *CIB nodes* represented as JSON objects - and, e.g., stored as files in the CIB directory or received through the REST API. These JSON objects are generated by various helper applications called *CIB sources*. A simple example of the CIB node defining a local interface is given below:

```
{
    "uid": "eth0",
    "root": true,
    "expire": -1,
    "priority": 4,
    "properties": {
        "interface": {"value": "eth0", "precedence":2},
        "capacity": {"value": 10000, "precedence":2},
        "local_ip": {"value": "10.10.2.1", "precedence":2},
        "is_wired": {"value": true, "precedence":2},
        "MTU": {"value": {"start":50, "end":9000}}
    }
}
```

Each CIB node includes a `uid` key and a set of `properties` to be included in the CIB row. 


## Extending Existing CIB Nodes

Additionally, CIB sources may generate CIB nodes which reference and extend pre-existing **CIB nodes**. This feature is used to inject network characteristics collected by external sources (e.g., controllers). For example, the following two CIB nodes reference the file above:

```
{
    "uid": "eth0_remote_1",
    "description": "information about remote endpoint 1",
    "priority": 2,
    "link": true,
    "match" : [
    	{"uid": {"value": "eth0"}}
    ],
    "properties": {
        "remote_ip": {"value": "8.8.8.8", "precedence":2, "score": 2},
        "port": {"value": "80", "precedence":2, "score": 1}
    }
}
```
and

```
{
    "uid": "eth0_remote_2",
    "description": "information about remote endpoint 2",
    "priority": 2,
    "link": true,
    "match" : [
    	{"interface": {"value": "eth0"}, "local_ip": {"value": "10.10.2.1"}}
    ],
    "properties": {
        "remote_ip": {"value": "8.8.4.4.", "precedence":2, "score": 2},
    }
}
```


If a CIB node contains a `link` attribute that is set to `true` the CIB will attempt to match any property or `uid` listed in the `match` attribute, and will append the new properties to the corresponding CIB node. Both examples above will be linked to the interface `eth0`, defined in the first CIB node. To reference multiple CIBs, the match attribute list can contain multiple JSON objects. The priority attribute is used to resolve overlapping properties.

Essentially, the CIB internally constructs a directed graph using all available CIB nodes. To generate the CIB rows, the graph is resolved starting at each node which has the attribute `root` set to `true` (see CIB node 1), generating paths (i.e., rows) by traversing the graph in the reverse direction of the edges (TODO clarify).

Hence, from the above CIB nodes the CIB will generate the following two rows:

```
1: {"interface": {"value": "eth0", "precedence":2}, "capacity": {"value": 10000, "precedence":2}, "local_ip": {"value": "10.10.2.1", "precedence":2}, "is_wired": {"value": true, "precedence":2}, "MTU": {"value": {"start":50, "end":9000}, "remote_ip": {"value": "8.8.8.8", "precedence":2, "score": 2}, "port": {"value": "80", "precedence":2, "score": 1}}

2: {"interface": {"value": "eth0", "precedence":2}, "capacity": {"value": 10000, "precedence":2}, "local_ip": {"value": "10.10.2.1", "precedence":2}, "is_wired": {"value": true, "precedence":2}, "MTU": {"value": {"start":50, "end":9000}, "remote_ip": {"value": "8.8.4.4.", "precedence":2, "score": 2}}
        

```


## Extending CIB Rows

Finally, CIB sources have the option of generating CIB nodes which augment existing CIB **rows** with additional properties. This can be useful to annotate specific CIB rows with historical information, e.g., collected from previous connections. To achieve this the `link` attribute is set to `false`:

```
{
    "uid": "historic info",
    "description": "appended properties to CIB rows matching all match properties.",
    "priority": 10,
    "expire": 1476104788,
    "link": false,
    "match": [
    	{ "interface": {"value": "eth0"}, 
         "local_ip": {"value": "10.10.2.1"}, 
         "remote_ip": {"value": "8.8.8.8"}}        
     ],
    "properties": [{
        "port": {"value": 8080, "precedence":1},
        "local_port": {"value": 56674, "precedence":1},
        "transport": {"value": "TCP", "precedence":1},
        "__cached": {"value": true, "precedence":2, "score":5}
    }]
}

```

For this example the CIB will match row 1, and insert a **new** row which includes the additional properties.

```
3: {"interface": {"value": "eth0", "precedence":2}, "capacity": {"value": 10000, "precedence":2}, "local_ip": {"value": "10.10.2.1", "precedence":2}, "is_wired": {"value": true, "precedence":2}, "MTU": {"value": {"start":50, "end":9000}, "remote_ip": {"value": "8.8.8.8", "precedence":2, "score": 2}, "port": {"value": 8080, "precedence":1}, "local_port": {"value": 56674, "precedence":1}, "transport": {"value": "TCP", "precedence":1}, "__cached": {"value": true, "precedence":2, "score":5}}

```
